/*
 * Decompiled with CFR 0.152.
 */
package signal;

import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import shared.ByteStream;
import signal.Signal;

public class ReplyTrackerImageSignal
extends Signal {
    private byte m_sourceTrackerNumber;
    private byte m_destinationTrackerNumber;
    private BufferedImage m_sourceTrackerImage;
    public static final int LENGTH = 14;

    private ReplyTrackerImageSignal() {
        super(13);
    }

    public ReplyTrackerImageSignal(byte sourceTrackerNumber, byte destinationTrackerNumber, BufferedImage sourceTrackerImage) {
        super(13);
        this.m_sourceTrackerNumber = sourceTrackerNumber;
        this.m_destinationTrackerNumber = destinationTrackerNumber;
        this.m_sourceTrackerImage = sourceTrackerImage;
    }

    public byte getSourceTrackerNumber() {
        return this.m_sourceTrackerNumber;
    }

    public byte getDestinationTrackerNumber() {
        return this.m_destinationTrackerNumber;
    }

    public BufferedImage getSourceTrackerImage() {
        return this.m_sourceTrackerImage;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_sourceTrackerNumber);
        checksum += ByteStream.getChecksum(this.m_destinationTrackerNumber);
        return checksum += ByteStream.getChecksum(this.m_sourceTrackerImage);
    }

    public static ReplyTrackerImageSignal readFrom(ByteStream byteStream, DataInputStream in) {
        if (byteStream == null) {
            return null;
        }
        ReplyTrackerImageSignal s2 = new ReplyTrackerImageSignal();
        s2.m_sourceTrackerNumber = byteStream.nextByte();
        s2.m_destinationTrackerNumber = byteStream.nextByte();
        byteStream.nextLong();
        int dataLength = byteStream.nextInteger();
        ByteStream imageStream = ByteStream.readFrom(in, dataLength);
        if (imageStream == null) {
            return null;
        }
        s2.m_sourceTrackerImage = imageStream.nextBufferedImage(dataLength);
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_sourceTrackerNumber);
        byteStream.addByte(this.m_destinationTrackerNumber);
        byteStream.addLong(this.checksum());
        byteStream.addBufferedImage(this.m_sourceTrackerImage);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Source Tracker ID: " + this.m_sourceTrackerNumber + " Destination Tracker ID: " + this.m_destinationTrackerNumber;
    }
}

