/*
 * Decompiled with CFR 0.152.
 */
package signal;

import java.io.DataOutputStream;
import shared.ByteStream;
import signal.SignalType;

public class Signal {
    protected int m_signalType;
    public static final int LENGTH = 12;

    public Signal(int signalType) {
        this.m_signalType = signalType;
    }

    public int getSignalType() {
        return this.m_signalType;
    }

    public long checksum() {
        return ByteStream.getChecksum(this.m_signalType);
    }

    public static Signal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        int id = byteStream.nextInteger();
        long idChecksum = byteStream.nextLong();
        if (ByteStream.getChecksum(id) != idChecksum) {
            return null;
        }
        return new Signal(id);
    }

    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        byteStream.addInteger(this.m_signalType);
        byteStream.addLong(ByteStream.getChecksum(this.m_signalType));
    }

    public void writeTo(DataOutputStream out) {
        if (out == null) {
            return;
        }
        ByteStream bs = new ByteStream();
        this.writeTo(bs);
        bs.writeTo(out);
    }

    public String toString() {
        return SignalType.toString(this.m_signalType);
    }
}

