/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class TaskStartedSignal
extends Signal {
    private byte m_taskID;
    private byte m_robotID;
    public static final int LENGTH = 10;

    private TaskStartedSignal() {
        super(6);
    }

    public TaskStartedSignal(byte robotID, byte taskID) {
        super(6);
        this.m_taskID = taskID;
        this.m_robotID = robotID;
    }

    public byte getTaskID() {
        return this.m_taskID;
    }

    public byte getRobotID() {
        return this.m_robotID;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_taskID);
        return checksum += ByteStream.getChecksum(this.m_robotID);
    }

    public static TaskStartedSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        TaskStartedSignal s2 = new TaskStartedSignal();
        s2.m_taskID = byteStream.nextByte();
        s2.m_robotID = byteStream.nextByte();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_taskID);
        byteStream.addByte(this.m_robotID);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Task ID: " + this.m_taskID + " Robot ID: " + this.m_robotID;
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return TaskStartedSignal.readFrom(byteStream);
    }
}

