/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import shared.Position;
import signal.Signal;

public class UpdateBlockPositionSignal
extends Signal {
    private byte m_blockID;
    private int m_x;
    private int m_y;
    public static final int LENGTH = 17;

    private UpdateBlockPositionSignal() {
        super(8);
    }

    public UpdateBlockPositionSignal(byte blockID, int x, int y) {
        super(8);
        this.m_blockID = blockID;
        this.m_x = x;
        this.m_y = y;
    }

    public byte getBlockID() {
        return this.m_blockID;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public Position getPosition() {
        return new Position(this.m_x, this.m_y);
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_blockID);
        checksum += ByteStream.getChecksum(this.m_x);
        return checksum += ByteStream.getChecksum(this.m_y);
    }

    public static UpdateBlockPositionSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        UpdateBlockPositionSignal s2 = new UpdateBlockPositionSignal();
        s2.m_blockID = byteStream.nextByte();
        s2.m_x = byteStream.nextInteger();
        s2.m_y = byteStream.nextInteger();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_blockID);
        byteStream.addInteger(this.m_x);
        byteStream.addInteger(this.m_y);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Block ID: " + this.m_blockID + " Position: (" + this.m_x + ", " + this.m_y + ")";
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return UpdateBlockPositionSignal.readFrom(byteStream);
    }
}

