/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import shared.Position;
import signal.Signal;

public class UpdatePotPositionSignal
extends Signal {
    private byte m_potID;
    private int m_x;
    private int m_y;
    public static final int LENGTH = 17;

    private UpdatePotPositionSignal() {
        super(9);
    }

    public UpdatePotPositionSignal(byte potID, int x, int y) {
        super(9);
        this.m_potID = potID;
        this.m_x = x;
        this.m_y = y;
    }

    public byte getPotID() {
        return this.m_potID;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public Position getPosition() {
        return new Position(this.m_x, this.m_y);
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_potID);
        checksum += ByteStream.getChecksum(this.m_x);
        return checksum += ByteStream.getChecksum(this.m_y);
    }

    public static UpdatePotPositionSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        UpdatePotPositionSignal s2 = new UpdatePotPositionSignal();
        s2.m_potID = byteStream.nextByte();
        s2.m_x = byteStream.nextInteger();
        s2.m_y = byteStream.nextInteger();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_potID);
        byteStream.addInteger(this.m_x);
        byteStream.addInteger(this.m_y);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Pot ID: " + this.m_potID + " Position: (" + this.m_x + ", " + this.m_y + ")";
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return UpdatePotPositionSignal.readFrom(byteStream);
    }
}

